<?php

use App\Models\Journal;
use App\Models\MenuItem;
use App\Models\Party;
use App\Models\PartyTransaction;
use App\Models\StockLedger;
use Illuminate\Support\Facades\Cache;

function storeResponse($route = null) {

    if ($route) {
        return to_route($route)->withSuccess('Data created successfully!');
    }

    return back()->withSuccess('Data created successfully!');
}

function updateResponse($route = null) {

    if ($route) {
        return to_route($route)->withSuccess('Data updated successfully!');
    }

    return back()->withSuccess('Data updated successfully!');
}

function deleteResponse($route = null) {

    if ($route) {
        return to_route($route)->withSuccess('Data deleted successfully!');
    }

    return back()->withSuccess('Data deleted successfully!');
}

function errorResponse($route = null) {

    if ($route) {
        return to_route($route)->withError('Something went wrong! Please try again later.');
    }

    return back()->withError('Something went wrong! Please try again later.');
}

function uploadImage($folder, $file) {

    if ($file) {

        $img_gen   = hexdec(uniqid());
        $image_url = 'images/' . $folder . '/';
        $image_ext = strtolower($file->getClientOriginalExtension());

        $img_name = $img_gen . '.' . $image_ext;
        $file->move($image_url, $img_name);

        return $image_url . $img_gen . '.' . $image_ext;
    }

    return null;
}

function menuItems() {
    $menu = MenuItem::whereNull('parent_id')
        ->with('subMenus')
        ->orderBy('priority')
        ->get();

    return $menu;
}

function partyTransaction(
    $party,
    $customer_balance,
    $supplier_balance,
    $transaction_type,
    $source_type = null,
    $source_id = null,
    $note = null
) {

    if ($customer_balance != 0 || $supplier_balance != 0) {

        $single_party         = Party::lockForUpdate()->find($party->id);
        $old_customer_balance = $single_party->transactions()->sum('customer_amount');
        $old_supplier_balance = $single_party->transactions()->sum('supplier_amount');

        $trnx                   = new PartyTransaction();
        $trnx->party_id         = $party->id;
        $trnx->transaction_date = now();
        $trnx->transaction_type = $transaction_type;
        $trnx->source_type      = $source_type;
        $trnx->source_id        = $source_id;
        $trnx->note             = $note;

        if ($party->type === 'customer' && $customer_balance != 0) {
            $trnx->customer_amount        = $customer_balance;
            $trnx->customer_balance_after = $old_customer_balance + $customer_balance;
            $trnx->save();
        } elseif ($party->type === 'supplier' && $supplier_balance != 0) {
            $trnx->supplier_amount        = $supplier_balance;
            $trnx->supplier_balance_after = $old_supplier_balance + $supplier_balance;
            $trnx->save();
        } else {

            if ($customer_balance != 0) {
                $trnx->customer_amount        = $customer_balance;
                $trnx->customer_balance_after = $old_customer_balance + $customer_balance;
            }

            if ($supplier_balance != 0) {
                $trnx->supplier_amount        = $supplier_balance;
                $trnx->supplier_balance_after = $old_supplier_balance + $supplier_balance;
            }

            $trnx->save();

        }

    }

    return true;

}

function stockLedgerTracking($product_id, $quantity, $type) {
    $ledger                  = new StockLedger();
    $ledger->product_id      = $product_id;
    $ledger->quantity_change = $quantity;
    $ledger->type            = $type;
    $ledger->unit_price      = null;
    $ledger->save();

    return true;
}

function activeMenu($route) {
    $parts = explode('.', $route);

    return request()->is($parts[0] . '*') ? 'active' : '';
}

function activeGroupMenu($route) {
    $parts = explode('.', $route);

    return request()->is($parts[0] . '*') ? 'show' : '';
}

function getJournalList() {
    $journals = Cache::rememberForever(
        Journal::listCacheKey(),
        fn() => Journal::orderBy('name')->get()
    );

    return $journals;
}

function getJournalBySlug($slug) {
    $journal = Cache::rememberForever(
    Journal::cacheKey($slug),
    fn () => Journal::with('journalCategories')
            ->where('slug', $slug)
            ->firstOrFail()
);

    return $journal;
}
