<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class AuthMail extends Mailable {
    use Queueable, SerializesModels;

    public $data;
    public function __construct($data) {
        $this->data = $data;
    }

    public function build() {

        return $this->subject($this->data['subject'])
            ->markdown('emails.auth-mail')
            ->with([
                'data' => $this->data,
            ]);
    }
}
