<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class JournalUserAssignment extends Model {
    protected $guarded   = [];
    public $incrementing = true;
    public function journal() {
        return $this->belongsTo(Journal::class);
    }

    public function assignable() {
        return $this->morphTo();
    }

    public function assignedBy() {
        return $this->belongsTo(User::class, 'assigned_by');
    }
}
