<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('journals', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('slug')->unique();
            $table->string('abr_name');
            $table->string('issn_print')->nullable();
            $table->string('issn_digital')->nullable();
            $table->string('coden')->nullable();
            $table->string('publication_frequency')->nullable();
            $table->string('publication_medium')->nullable();
            $table->integer('launched_year');
            $table->string('icon')->nullable();
            $table->string('color_family')->nullable();
            $table->longText('description')->nullable();
            $table->text('rating')->nullable();
            $table->string('j_format')->nullable();
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('journals');
    }
};
