<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('journal_user_assignments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('journal_id')
                ->constrained()
                ->cascadeOnDelete();

            $table->morphs('assignable'); 
            // assignable_id, assignable_type

            $table->enum('role', ['Reviewer', 'Editor']);

            $table->foreignId('assigned_by')
                ->nullable()
                ->constrained('users')
                ->nullOnDelete();

            $table->timestamps();

            $table->unique([
                'journal_id',
                'assignable_id',
                'assignable_type',
                'role'
            ], 'journal_assign_unique');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('journal_user_assignments');
    }
};
