<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('articles', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid')->unique();
            $table->unsignedBigInteger('journal_id');
            $table->unsignedBigInteger('journal_category_id')->nullable();
            $table->unsignedBigInteger('journal_statistics_id');
            $table->integer('volume');
            $table->integer('issue');
            $table->integer('serial_no');
            $table->text('doi')->nullable();

            $table->text('name');

            $table->json('keywords')->nullable();

            $table->enum('status', [
                'draft',
                'submitted',
                'under_editor_review',
                'under_review',
                'revision_required',
                'accepted',
                'rejected',
                'published'
            ])->default('draft');

            $table->timestamp('received_at')->nullable();
            $table->timestamp('revised_at')->nullable();
            $table->timestamp('accepted_at')->nullable();
            $table->timestamp('published_at')->nullable();
            $table->timestamp('rejected_at')->nullable();

            $table->string('jpr_docx')->nullable();
            $table->string('jpr_pdf')->nullable();
            $table->string('jpr_xml')->nullable();

            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('articles');
    }
};
