@extends('layouts.master')
@section('title', request()->id ? 'Edit existing journal' : 'Create new journal statistic')

@section('content')
    <div class="row">
        <div class="card">
            <x-back-button :route="route('journal-statistics.index')"></x-back-button>
            <div class="card-body">
                <form
                    action="{{ request()->id ? route('author.journal-submission.storeOrUpdate', request()->id) : route('author.journal-submission.storeOrUpdate') }}"
                    method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="row app-form">
                        <div class="col-4 mb-3">
                            <label class="form-label">journal*</label>
                            <select name="journal_id" id="journal_id" class="select-example form-select select-basic"
                                required>
                                <option value="">Select Journal</option>
                                @foreach ($journals as $journal)
                                    <option value="{{ $journal->id }}">{{ $journal->name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-4 mb-3">
                            <label class="form-label">journal category</label>
                            <select name="journal_category_id" id="journal_category_id"
                                class="select-example form-select select-basic" disabled>
                                <option value="">Select Category</option>
                            </select>
                        </div>

                        <div class="col-4 mb-3">
                            <label class="form-label">journal statistic*</label>
                            <select name="journal_statistics_id" id="journal_statistics_id"
                                class="select-example form-select select-basic" required disabled>
                                <option value="">Select Statistic</option>
                            </select>
                        </div>

                        <x-submit-button></x-submit-button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@section('js')
    <script>
        $(document).ready(function() {
            // When Journal Changes
            $('#journal_id').on('change', function() {
                let journalId = $(this).val();
                $('#journal_category_id').empty().append('<option value="">Loading...</option>').prop(
                    'disabled', true);
                $('#journal_statistics_id').empty().append('<option value="">Select Statistic</option>')
                    .prop('disabled', true);

                if (journalId) {
                    $.ajax({
                        url: '/get-journal-categories/' + journalId,
                        type: 'GET',
                        success: function(data) {
                            $('#journal_category_id').empty().append(
                                '<option value="">Select Category</option>').prop(
                                'disabled', false);
                            $.each(data, function(key, value) {
                                $('#journal_category_id').append('<option value="' +
                                    value.id + '">' + value.name + '</option>');
                            });
                        }
                    });

                    $.ajax({
                        url: '/get-journal-statistics/' + journalId,
                        type: 'GET',
                        success: function(data) {
                            $('#journal_statistics_id').empty().append(
                                '<option value="">Select Statistic</option>').prop(
                                'disabled', false);
                            $.each(data, function(key, value) {
                                $('#journal_statistics_id').append('<option value="' +
                                    value.id + '">Volume: ' + value.volume +
                                    ', Issue: ' + value.issue + '</option>');
                            });
                        }
                    });
                }
            });
        });
    </script>
@endsection
