@extends('layouts.master')
@section('title', 'Company information')
@section('css')
@endsection

@section('content')
    <div class="row">
        <h3 class="p-0">Company information</h3>
    </div>

    <div class="row">


        <div class="card">
            <div class="card-body">
                <form action="{{ route('company-infos.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="row app-form">
                        
                        <div class="col-6 mb-3">
                            <label class="form-label" for="name">business Name*</label>
                            <input type="text" name="name" id="name" class="form-control" required value="{{ $data->name ?? '' }}">
                        </div>

                        <div class="col-6 mb-3">
                            <label class="form-label" for="legal_name">Legal Name</label>
                            <input type="text" name="legal_name" id="legal_name" class="form-control" value="{{ $data->legal_name ?? '' }}">
                        </div>

                        <div class="col-6 mb-3">
                            <label class="form-label" for="website_url">Website URL</label>
                            <input type="url" name="website_url" id="website_url" class="form-control" value="{{ $data->website_url ?? '' }}">
                        </div>

                        <div class="col-6 mb-3">
                            <label class="form-label" for="registration_number">Registration Number</label>
                            <input type="text" name="registration_number" id="registration_number" class="form-control" value="{{ $data->registration_number ?? '' }}">
                        </div>

                        <div class="col-12 mb-3">
                            <label class="form-label" for="about">About</label>
                            <textarea name="about" id="about" class="form-control" rows="3">{{ $data->about ?? '' }}</textarea>
                        </div>

                        <div class="col-6 mb-3">
                            <label class="form-label" for="tagline">Tagline</label>
                            <input type="text" name="tagline" id="tagline" class="form-control" value="{{ $data->tagline ?? '' }}">
                        </div>

                        <div class="col-6 mb-3">
                            <label class="form-label" for="publication_name">Publication Name</label>
                            <input type="text" name="publication_name" id="publication_name" class="form-control" value="{{ $data->publication_name ?? '' }}">
                        </div>

                        <div class="col-6 mb-3">
                            <label class="form-label" for="state">State</label>
                            <input type="text" name="state" id="state" class="form-control" value="{{ $data->state ?? '' }}">
                        </div>

                        <div class="col-6 mb-3">
                            <label class="form-label" for="postal_address">Postal Address</label>
                            <input name="postal_address" id="postal_address" class="form-control" value="{{ $data->postal_address ?? '' }}">
                        </div>

                        <div class="col-6 mb-3">
                            <label class="form-label" for="contact_person_name">Contact Person Name</label>
                            <input type="text" name="contact_person_name" id="contact_person_name" class="form-control" value="{{ $data->contact_person_name ?? '' }}">
                        </div>

                        <div class="col-6 mb-3">
                            <label class="form-label" for="contact_person_email">Contact Person Email</label>
                            <input type="email" name="contact_person_email" id="contact_person_email" class="form-control" value="{{ $data->contact_person_email ?? '' }}">
                        </div>

                        <div class="col-6 mb-3">
                            <label class="form-label" for="phone">Phone</label>
                            <input type="tel" name="phone" id="phone" class="form-control" value="{{ $data->phone ?? '' }}">
                        </div>

                        <div class="col-6 mb-3">
                            <label class="form-label" for="email">Email</label>
                            <input type="email" name="email" id="email" class="form-control" value="{{ $data->email ?? '' }}">
                        </div>

                        <div class="col-6 mb-3">
                            <label class="form-label" for="default_currency">Default Currency</label>
                            <input type="text" name="default_currency" id="default_currency" class="form-control" value="{{ $data->default_currency ?? '' }}">
                        </div>

                        <div class="col-3 mb-3">
                            <label class="form-label" for="logo">Logo</label>
                            <input type="file" name="logo" id="logo" class="form-control">
                            @if (isset($data->logo))
                                <img src="{{ asset($data->logo) }}" alt="Logo" class="img-fluid mt-2" style="max-height: 100px;">
                            @endif
                        </div>

                        <div class="col-3 mb-3">
                            <label class="form-label" for="favicon">Favicon</label>
                            <input type="file" name="favicon" id="favicon" class="form-control">
                            @if (isset($data->favicon))
                                <img src="{{ asset($data->favicon) }}" alt="Favicon" class="img-fluid mt-2" style="max-height: 100px;">
                            @endif
                        </div>

                        <div class="col-12 mb-3">
                            <label class="form-label" for="meta_title">Meta Title</label>
                            <input type="text" name="meta_title" id="meta_title" class="form-control" value="{{ $data->meta_title ?? '' }}">
                        </div>

                        <div class="col-12 mb-3">
                            <label class="form-label" for="meta_keyword">Meta Keyword (use comma to separate the words)</label>
                            <textarea name="meta_keyword" id="meta_keyword" class="form-control" rows="2">{{ $data->meta_keyword ?? '' }}</textarea>
                        </div>

                        <div class="col-12 mb-3">
                            <label class="form-label" for="meta_description">Meta Description</label>
                            <textarea name="meta_description" id="meta_description" class="form-control" rows="3">{{ $data->meta_description ?? '' }}</textarea>
                        </div>

                        <x-submit-button></x-submit-button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@section('js')

@endsection
