{{-- branch/index-data-rows.blade.php --}}
@foreach ($data as $item)
    <tr>
        <td>{{ $item->journal->name ?? 'N/A' }}</td>
        <td>{{ $item->volume ?? 'N/A' }}</td>
        <td>{{ $item->issue ?? 'N/A' }}</td>
        <td>{{ $item->start_date ? $item->start_date->format('d M Y') : 'N/A' }}</td>
        <td>{{ $item->end_date ? $item->end_date->format('d M Y') : 'N/A' }}</td>
        <td>
            <b>BY: </b>{{ $item->createdBy->name ?? 'N/A' }}, <br>
            <b>ON: </b>{{ $item->created_at->format('d M Y h:i A') ?? 'N/A' }}
        </td>
        <td>
            <b>BY: </b>{{ $item->updatedBy->name ?? 'N/A' }}, <br>
            <b>ON: </b>{{ $item->updated_at->format('d M Y h:i A') ?? 'N/A' }}
        </td>
        <td>
            <div class="d-flex justify-content-around">
                <x-edit-button :route="route('journal-statistics.edit', $item->id)"></x-edit-button>
                <x-delete-button :route="route('journal-statistics.destroy', $item)"></x-delete-button>
            </div>
        </td>
    </tr>
@endforeach
