@extends('layouts.master')
@section('title', 'Edit existing journal')
@section('css')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.9.1/summernote-bs5.min.css" />
@endsection

@section('content')
    <div class="row">
        <h3 class="p-0">Edit existing journal</h3>
    </div>

    <div class="row">


        <div class="card">
            <x-back-button :route="route('journals.index')"></x-back-button>
            <div class="card-body">
                <form action="{{ route('journals.update', $data) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <div class="row app-form">
                        <div class="col-6 mb-3">
                            <label class="form-label" for="name">Full Name*</label>
                            <input type="text" name="name" id="name" class="form-control"
                                value="{{ $data->name }}" required>
                        </div>

                        <div class="col-6 mb-3">
                            <label class="form-label" for="abr_name">Journal ABBR. Name*</label>
                            <input type="text" name="abr_name" id="abr_name" class="form-control"
                                value="{{ $data->abr_name }}" required>
                        </div>

                        <div class="col-4 mb-3">
                            <label class="form-label" for="issn_print">ISSN Print*</label>
                            <input type="text" name="issn_print" id="issn_print" class="form-control"
                                value="{{ $data->issn_print }}" required>
                        </div>
                        <div class="col-4 mb-3">
                            <label class="form-label" for="issn_digital">ISSN Digital*</label>
                            <input type="text" name="issn_digital" id="issn_digital" class="form-control"
                                value="{{ $data->issn_digital }}" required>
                        </div>
                        <div class="col-4 mb-3">
                            <label class="form-label" for="launched_year">Launched Year*</label>
                            <input type="number" name="launched_year" id="launched_year" class="form-control"
                                value="{{ $data->launched_year }}" required>
                        </div>
                        <div class="col-4 mb-3">
                            <label class="form-label" for="coden">CODEN*</label>
                            <input type="text" name="coden" id="coden" class="form-control"
                                value="{{ $data->coden }}">
                        </div>
                        <div class="col-4 mb-3">
                            <label class="form-label" for="publication_frequency">Publication Frequency</label>
                            <input type="text" name="publication_frequency" id="publication_frequency"
                                class="form-control" value="{{ $data->publication_frequency }}">
                        </div>

                        <div class="col-4 mb-3">
                            <label class="form-label" for="publication_medium">Publication Medium</label>
                            <input type="text" name="publication_medium" id="publication_medium" class="form-control"
                                value="{{ $data->publication_medium }}">
                        </div>

                        <div class="col-12 mb-3">
                            <label class="form-label" for="">Journal Description</label>
                            <textarea name="description" class="form-control" id="summernote">{!! $data->description !!}</textarea>
                        </div>

                        <div class="col-4 mb-3">
                            <label class="form-label" for="j_format">Journal Format</label>
                            <input type="file" name="j_format" id="j_format" class="form-control">
                            @if ($data->j_format)
                                <a href="{{ asset($data->j_format) }}" target="_blank">View Current Format</a>
                            @endif
                        </div>
                        <div class="col-4 mb-3">
                            <label class="form-label" for="icon">Journal icon</label>
                            <input type="file" name="icon" id="icon" class="form-control">
                            @if ($data->icon)
                                <img alt="avatar" class="img-fluid b-r-10 mt-2" src="{{ asset($data->icon) }}"
                                    style="height: 35px;">
                            @endif
                        </div>

                        <div class="col-4 mb-3">
                            <label class="form-label" for="color_family" style="background-color: {{ $data->color_family }}">Color Family</label>
                            <input type="color" name="color_family" id="color_family" class="form-control"
                                value="{{ $data->color_family }}">
                        </div>

                        <x-submit-button></x-submit-button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.9.1/summernote-bs5.min.js"></script>
@endsection
