{{-- @foreach ($menuItems as $menuItem)
    <div>
        <input type="checkbox" name="menu_items[]" value="{{ $menuItem->id }}"
            @if ($permissions->contains('menu_item_id', $menuItem->id)) checked @endif />
        <label>{{ $menuItem->name }}</label>
    </div>
@endforeach --}}
<style>
    /* General styling for menu items */
    .menu-item {
        margin-bottom: 20px;
        padding-left: 10px;
        border-left: 3px solid #007bff;
        /* Adds a visual left border to main menu */
        background-color: #f9f9f9;
        /* Light gray background for main menu */
        padding-top: 10px;
    }

    .menu-item .main-menu {
        margin: 10px 0;
        font-weight: bold;
        font-size: 16px;
    }

    .menu-item .main-menu input[type="checkbox"] {
        margin-right: 10px;
    }

    .menu-item .main-menu label {
        font-size: 16px;
        color: #333;
        cursor: pointer;
    }

    /* Styling for submenus */
    .submenu-container {
        padding-left: 20px;
        /* Indent submenus */
        margin-top: 10px;
    }

    .submenu {
        margin-left: 20px;
        padding: 5px 0;
        font-size: 14px;
        background-color: #f0f0f0;
    }

    .submenu input[type="checkbox"] {
        margin-right: 10px;
    }

    .submenu label {
        color: #555;
        cursor: pointer;
    }

    /* Submenu hover effect */
    .submenu:hover {
        background-color: #e0e0e0;
    }

    .submenu-label {
        transition: color 0.3s ease;
    }

    /* Highlight submenu when checked */
    input[type="checkbox"]:checked+label {
        color: #007bff;
    }

    /* Styling for the whole menu section */
    #menu-permissions {
        margin-top: 20px;
    }
</style>

@foreach ($menuItems as $menuItem)
    @if ($menuItem->parent_id == null)
        <div class="menu-item">
            <div class="main-menu">
                <input type="checkbox" name="menu_items[]" value="{{ $menuItem->id }}"
                    @php
                        $permission = $permissions->firstWhere('menu_item_id', $menuItem->id);
                    @endphp
                    @if ($permission && $permission->can_access) checked @endif />
                <label class="menu-label">{{ $menuItem->name }}</label>
            </div>

            <!-- Submenus -->
            @if ($menuItem->subMenus->isNotEmpty())
                <div class="submenu-container">
                    @foreach ($menuItem->subMenus as $subMenuItem)
                        <div class="submenu">
                            <input type="checkbox" name="menu_items[]" value="{{ $subMenuItem->id }}"
                                @php
                                    $subMenuPermission = $permissions->firstWhere('menu_item_id', $subMenuItem->id);
                                @endphp
                                @if ($subMenuPermission && $subMenuPermission->can_access) checked @endif />
                            <label class="submenu-label">{{ $subMenuItem->name }}</label>
                        </div>
                    @endforeach
                </div>
            @endif
        </div>
    @endif
@endforeach

