{{-- branch/index-data-rows.blade.php --}}
@foreach ($data as $item)
    <tr>
        <td>{{ $item->name }}</td>
        <td>{{ $item->note }}</td>
        <td>
            <b>By: </b>{{ $item->createdBy->name ?? 'N/A' }}, <br>
            <b>At: </b>{{ $item->created_at->format('d F, Y') }}
        </td>
        <td>
            <b>By: </b>{{ $item->updatedBy->name ?? 'N/A' }}, <br>
            <b>At: </b>{{ $item->updated_by ? $item->updated_at->format('d F, Y') : 'N/A' }}
        </td>
        <td>
            <div class="d-flex justify-content-around">
                <x-edit-button :route="route('site-designations.edit', $item->id)"></x-edit-button>
                <x-delete-button :route="route('site-designations.destroy', $item)"></x-delete-button>
            </div>
        </td>
    </tr>
@endforeach
