@extends('layouts.master')
@section('title', 'Edit existing user')
@section('css')
@endsection

@section('content')
    <div class="row">
        <h3 class="p-0">Edit existing user</h3>
    </div>

    <div class="row">


        <div class="card">
            <x-back-button :route="route('users.index')"></x-back-button>
            <div class="card-body">
                <form action="{{ route('users.update', $data) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <div class="row app-form">
                        <div class="col-6 mb-3">
                            <label class="form-label" for="name"> Name*</label>
                            <input type="text" name="name" id="name" class="form-control"
                                value="{{ $data->name }}" required>
                        </div>

                        <div class="col-3 mb-3">
                            <label class="form-label" for="Gender">Gender</label>
                            <select name="gender" class="select-example form-select select-basic">
                                <option value="">Select option</option>
                                <option value="Male" {{ $data->gender === 'Male' ? 'selected' : '' }}>Male</option>
                                <option value="Female" {{ $data->gender === 'Female' ? 'selected' : '' }}>Female</option>
                                <option value="Other" {{ $data->gender === 'Other' ? 'selected' : '' }}>Other</option>
                            </select>
                        </div>

                        <div class="col-3 mb-3">
                            <label class="form-label" for="dob">Date of Birth</label>
                            <input type="date" name="dob" id="dob" class="form-control"
                                value="{{ $data->dob }}">
                        </div>

                        <div class="col-6 mb-3">
                            <label class="form-label" for="email">email*</label>
                            <input type="email" name="email" id="email" class="form-control"
                                value="{{ $data->email }}" required>
                        </div>
                        <div class="col-6 mb-3">
                            <label class="form-label" for="password">password*</label>
                            <input type="text" name="password" id="password" class="form-control">
                        </div>

                        <div class="col-3 mb-3">
                            <label class="form-label" for="Role">Role*</label>
                            <select name="role" class="select-example form-select select-basic" required>
                                <option value="Admin" {{ $data->role === 'Admin' ? 'selected' : '' }}>Admin</option>
                                <option value="Editor" {{ $data->role === 'Editor' ? 'selected' : '' }}>Editor</option>
                                <option value="Author" {{ $data->role === 'Author' ? 'selected' : '' }}>Author</option>
                            </select>
                        </div>
                        <div class="col-3 mb-3">
                            <label class="form-label" for="is_active">Is_Active*</label>
                            <select name="is_active" class="select-example form-select select-basic" required>
                                <option value="1" {{ $data->is_active === 1 ? 'selected' : '' }}>Yes</option>
                                <option value="0" {{ $data->is_active === 0 ? 'selected' : '' }}>No</option>
                            </select>
                        </div>
                        <div class="col-3 mb-3">
                            <label class="form-label" for="site_designation_id">{{ config('app.name') }}
                                Designation</label>
                            <select name="site_designation_id" class="select-example form-select select-basic">
                                <option value="">Select option</option>
                                @foreach ($designations as $designation)
                                    <option value="{{ $designation->id }}"
                                        {{ $data->site_designation_id == $designation->id ? 'selected' : '' }}>
                                        {{ $designation->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-3 mb-3">
                            <label class="form-label" for="website">Personal website link</label>
                            <input type="text" name="website" id="website" class="form-control"
                                value="{{ $data->website }}">
                        </div>

                        <div class="col-6 mb-3">
                            <label class="form-label" for="">Bio</label>
                            <textarea name="bio" class="form-control" rows="4">{{ $data->bio }}</textarea>
                        </div>
                        <div class="col-6 mb-3">
                            <label class="form-label" for="">Working History</label>
                            <textarea name="working_history" class="form-control" rows="4">{{ $data->working_history }}</textarea>
                        </div>
                        <div class="col-6 mb-3">
                            <label class="form-label" for="sci_profile">SciProfiles Link</label>
                            <input type="text" name="sci_profile" id="sci_profile" class="form-control"
                                value="{{ $data->sci_profile }}">
                        </div>
                        <div class="col-6 mb-3">
                            <label class="form-label" for="scilit">Scilit Profile Link</label>
                            <input type="text" name="scilit" id="scilit" class="form-control"
                                value="{{ $data->scilit }}">
                        </div>
                        <div class="col-6 mb-3">
                            <label class="form-label" for="preprint">Preprints.org Profile Link</label>
                            <input type="text" name="preprint" id="preprint" class="form-control"
                                value="{{ $data->preprint }}">
                        </div>
                        <div class="col-6 mb-3">
                            <label class="form-label" for="google_scholar">Google Scholar Profile Link</label>
                            <input type="text" name="google_scholar" id="google_scholar" class="form-control"
                                value="{{ $data->google_scholar }}">
                        </div>
                        <div class="col-6 mb-3">
                            <label class="form-label" for="hobbies">Hobbies</label>
                            <input type="text" name="hobbies" id="hobbies" class="form-control"
                                value="{{ $data->hobbies }}">
                        </div>
                        <div class="col-6 mb-3">
                            <label class="form-label" for="">Address</label>
                            <textarea name="address" class="form-control" rows="1">{{ $data->address }}</textarea>
                        </div>

                        <div class="col-12 mb-3">
                            <label class="form-label" for="image">Image</label>
                            <input type="file" name="image" id="image" class="form-control"
                                onchange="previewImage(event)">


                            <div id="image-preview-container">
                                @if ($data->image)
                                    <img src="{{ asset($data->image) }}" alt="#" width="100">
                                @endif
                            </div>
                        </div>

                        <x-submit-button></x-submit-button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@section('js')
@endsection
