{{-- branch/index-data-rows.blade.php --}}
@foreach ($data as $item)
    <tr>
        <td>
            @if ($item->image)
                <img alt="avatar" class="img-fluid b-r-10" src="{{ asset($item->image) }}" style="height: 35px;">
            @else
                <img alt="avatar" class="img-fluid b-r-10" src="{{ asset('assets/images/avatar/3.png') }}"
                    style="height: 35px;">
            @endif
        </td>
        <td>{{ $item->name }}</td>
        <td>{{ $item->email }}</td>
        <td>{{ $item->role }}</td>
        <td>{{ $item->is_active == 1 ? 'Yes' : 'No' }}</td>
        <td>{{ $item->siteDesignation->name ?? 'N/A' }}</td>
        <td>{{ $item->created_at->format('d F, Y') }}</td>
        <td>
            <div class="d-flex justify-content-around">
                @if ($item->id == 1)
                    <span class="text-muted">System Administrator</span>
                @else
                    <x-edit-button :route="route('users.edit', $item->id)"></x-edit-button>
                    <x-delete-button :route="route('users.destroy', $item)"></x-delete-button>
                @endif
            </div>
        </td>
    </tr>
@endforeach
