<style>
    .pagination-list {
        display: flex;
        list-style: none;
        padding: 0;
        margin: 20px 0;
        font-family: sans-serif;
    }

    .pagination-item {
        margin: 0 5px;
    }

    .pagination-link {
        display: block;
        padding: 10px 15px;
        border: 1px solid #ccc;
        border-radius: 4px;
        text-decoration: none;
        color: #333;
        background-color: #f9f9f9;
        transition: background-color 0.3s ease;
    }

    .pagination-item:first-child .pagination-link,
    .pagination-item:last-child .pagination-link {
        background-color: #eee;
    }

    .pagination-link:hover {
        background-color: #e0e0e0;
    }

    .pagination-item.active .pagination-link {
        background-color: #1e847f;
        /* Teal color from your image */
        color: white;
        border-color: #1e847f;
    }

    .pagination-item.disabled .pagination-link {
        background-color: #f0f0f0;
        color: #999;
        cursor: not-allowed;
        border-color: #ddd;
    }

    /* Optional: Adjust for the subtle border-dashed look if desired */
    .pagination-item:not(.active) .pagination-link {
        border-style: dashed;
        /* For the dashed border effect */
        border-color: #ddd;
    }
</style>
@if ($paginator->hasPages())
    <div class="d-flex justify-content-end">
        <ul class="pagination-list">
            {{-- Previous Page Link --}}
            @if ($paginator->onFirstPage())
                <li class="pagination-item disabled" aria-disabled="true">
                    <span class="pagination-link">Previous</span>
                </li>
            @else
                <li class="pagination-item">
                    <a class="pagination-link" href="{{ $paginator->previousPageUrl() }}" rel="prev">Previous</a>
                </li>
            @endif

            {{-- Pagination Elements --}}
            @foreach ($elements as $element)
                {{-- "Three Dots" Separator --}}
                @if (is_string($element))
                    <li class="pagination-item disabled" aria-disabled="true">
                        <span class="pagination-link">{{ $element }}</span>
                    </li>
                @endif

                {{-- Array Of Links --}}
                @if (is_array($element))
                    @foreach ($element as $page => $url)
                        @if ($page == $paginator->currentPage())
                            <li class="pagination-item active" aria-current="page">
                                <span class="pagination-link">{{ $page }}</span>
                            </li>
                        @else
                            <li class="pagination-item">
                                <a class="pagination-link" href="{{ $url }}">{{ $page }}</a>
                            </li>
                        @endif
                    @endforeach
                @endif
            @endforeach

            {{-- Next Page Link --}}
            @if ($paginator->hasMorePages())
                <li class="pagination-item">
                    <a class="pagination-link" href="{{ $paginator->nextPageUrl() }}" rel="next">Next</a>
                </li>
            @else
                <li class="pagination-item disabled" aria-disabled="true">
                    <span class="pagination-link">Next</span>
                </li>
            @endif
        </ul>
    </div>
@endif
