@extends('layouts.master')
@section('title', 'Welcome')
@section('css')
@endsection

@section('content')

    <body class="min-vh-100 d-flex align-items-center justify-content-center p-4 text-white">

        <!-- Admin Welcome Card -->
        <div class="admin-card w-100 bg-dark shadow-lg rounded-3 p-4 p-md-5 transition-all duration-300">

            <!-- Header Section -->
            <header class="text-center mb-5">
                <!-- Gear Icon: using a standard Bootstrap color (text-info for indigo-like) -->
                <svg class="mb-4 text-info" style="width: 64px; height: 64px;" fill="none" stroke="currentColor"
                    viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37h.001z">
                    </path>
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                </svg>
                <h1 class="display-4 fw-bold text-white mb-0">
                    {{ auth()->user()->name }}
                </h1>
                <p class="text-info lead mt-2">Welcome Back, as, {{ auth()->user()->role }}.</p>
            </header>

            <!-- Main Content Area -->
            <div class="text-center text-light">
                <p class="fs-5">
                    You have successfully logged into the system dashboard. Your current role grants you full access to user
                    management, configuration settings, and detailed analytics reports.
                </p>
            </div>

        </div>

        <script>
            /**
             * Function to simulate the logout process.
             * Uses Bootstrap classes for the notification style.
             */
            function handleLogout() {
                console.log("Logout process initiated...");

                // Create a temporary Bootstrap alert message box
                const messageBox = document.createElement('div');
                messageBox.id = 'statusMessage';
                // Use Bootstrap positioning (fixed-top-end) and alert styling (alert-success)
                messageBox.className = 'position-fixed top-0 end-0 m-4 alert alert-success alert-dismissible fade-transition';
                messageBox.setAttribute('role', 'alert');
                messageBox.textContent = 'Session terminated. Logging out...';

                // Set initial opacity for the fade-in effect
                messageBox.style.opacity = '0';
                messageBox.style.transform = 'translateY(-20px)'; /* Start slightly above */

                document.body.appendChild(messageBox);

                // Animate in
                setTimeout(() => {
                    messageBox.style.opacity = '1';
                    messageBox.style.transform = 'translateY(0)';
                }, 50);

                // Animate out after a few seconds
                setTimeout(() => {
                    messageBox.style.opacity = '0';
                    messageBox.style.transform = 'translateY(-20px)';
                }, 2500);

                // Remove after fade-out
                setTimeout(() => {
                    messageBox.remove();
                    // Optional: Redirect to login page in a real app
                    // window.location.href = "/admin-login"; 
                }, 3000);
            }
        </script>

        <!-- Load Bootstrap 5 JS (optional but good practice) -->
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"
            xintegrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous">
        </script>
    </body>
@endsection
@section('js')
@endsection
